
package easik.sketch.util.Export.Text;

import java.io.File;

import javax.swing.filechooser.FileFilter;

import easik.sketch.util.Export.ExportConstants;

/**
 * Class extending FileFilter to select only those files ending in <b>.sql</b>
 * 
 * @author Rob Fletcher 2005
 * @author Vera Ranieri 2006
 * @since 2006-05-17 Vera Ranieri
 * @version 2006-05-17 Vera Ranieri
 */
public class SQLFileFilter extends FileFilter {

	/**
	 * Overloaded method to check whether file has .sql extension.
	 * 
	 * @param f The file being considered
	 * @return True if the file ends in .sql .  False otherwise.
	 */
	public boolean accept(File f) {
		if ( f.getName().endsWith(ExportConstants.SQL_EXTENSION) ) {
			return true; 
		}		
		if (f.isDirectory()) return true;		
		return false;	
	}

	/**
	 * Returns accepted extensions, that is, .sql .
	 * 
	 * @return Extension *.sql
	 */
	public String getDescription() {
		return "*" + ExportConstants.SQL_EXTENSION;
	}
}
